/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.silentchaos512.gear.api.material.IMaterialCategory;

public enum MaterialCategories implements IMaterialCategory
{
    METAL,
    GEM,
    ROCK,
    DUST,
    CLOTH,
    FIBER,
    WOOD,
    ORGANIC,
    SLIME,
    SHEET,
    INTANGIBLE;

    private static final Map<String, IMaterialCategory> CACHE;

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static IMaterialCategory get(String key) {
        return CACHE.computeIfAbsent(key, key1 -> {
            for (MaterialCategories cat : MaterialCategories.values()) {
                if (!cat.getName().equalsIgnoreCase((String)key1)) continue;
                return cat;
            }
            String key2 = key1.toLowerCase(Locale.ROOT);
            return () -> key2;
        });
    }

    static {
        CACHE = new HashMap<String, IMaterialCategory>();
    }
}

