/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.crafting.recipe.DamageItemRecipe;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;

public class SGearDamageItemRecipe
extends DamageItemRecipe {
    private final int minGearTear;

    public SGearDamageItemRecipe(ShapelessRecipe recipe, int minGearTear) {
        super(recipe);
        this.minGearTear = minGearTear;
    }

    public boolean m_5818_(CraftingContainer inv, Level worldIn) {
        return super.m_5818_(inv, worldIn) && this.gearItemsMatchForCrafting((Container)inv);
    }

    private boolean gearItemsMatchForCrafting(Container inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!GearHelper.isGear(stack) || !GearHelper.isBroken(stack) || GearData.getTier(stack) < this.minGearTear) continue;
            return false;
        }
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<SGearDamageItemRecipe> {
        public SGearDamageItemRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int tier = GsonHelper.m_13824_((JsonObject)json, (String)"minGearTier", (int)0);
            return new SGearDamageItemRecipe((ShapelessRecipe)DamageItemRecipe.SERIALIZER.fromJson(recipeId, json), tier);
        }

        @Nullable
        public SGearDamageItemRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            DamageItemRecipe read = (DamageItemRecipe)DamageItemRecipe.SERIALIZER.fromNetwork(recipeId, buffer);
            int tier = buffer.m_130242_();
            return read != null ? new SGearDamageItemRecipe((ShapelessRecipe)read, tier) : null;
        }

        public void toNetwork(FriendlyByteBuf buffer, SGearDamageItemRecipe recipe) {
            DamageItemRecipe.SERIALIZER.toNetwork(buffer, (ExtendedShapelessRecipe)recipe);
            buffer.m_130130_(recipe.minGearTear);
        }
    }
}

