/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multiset;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.GsonHelper;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.util.StatGearKey;

public class StatModifierMap
implements Multimap<StatGearKey, StatInstance> {
    public static final StatModifierMap EMPTY_STAT_MAP = new StatModifierMap();
    private final Multimap<StatGearKey, StatInstance> map = MultimapBuilder.linkedHashKeys().arrayListValues().build();

    public static MutableComponent formatText(Collection<StatInstance> mods, ItemStat stat, int maxDecimalPlaces) {
        return StatModifierMap.formatText(mods, stat, maxDecimalPlaces, false);
    }

    public static MutableComponent formatText(Collection<StatInstance> mods, ItemStat stat, int maxDecimalPlaces, boolean addModColors) {
        if (mods.size() == 1) {
            StatInstance inst2 = mods.iterator().next();
            int decimalPlaces = inst2.getPreferredDecimalPlaces(stat, maxDecimalPlaces);
            return inst2.getFormattedText(stat, decimalPlaces, addModColors);
        }
        MutableComponent result = Component.m_237113_((String)"");
        ArrayList<StatInstance> toSort = new ArrayList<StatInstance>(mods);
        toSort.sort(Comparator.comparing(inst -> inst.getOp().ordinal()));
        for (StatInstance inst3 : toSort) {
            if (!result.m_7360_().isEmpty()) {
                result.m_130946_(", ");
            }
            result.m_7220_((Component)inst3.getFormattedText(stat, inst3.getPreferredDecimalPlaces(stat, maxDecimalPlaces), addModColors));
        }
        return result;
    }

    public Set<ItemStat> getStats() {
        HashSet<ItemStat> set = new HashSet<ItemStat>();
        for (StatGearKey key : this.keySet()) {
            if (!(key.getStat() instanceof ItemStat)) continue;
            set.add((ItemStat)key.getStat());
        }
        return set;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(@Nullable Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(@Nullable Object value) {
        return this.map.containsValue(value);
    }

    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        return this.map.containsEntry(key, value);
    }

    public boolean put(IItemStat stat, GearType gearType, StatInstance value) {
        return this.put(StatGearKey.of(stat, gearType), value);
    }

    public boolean put(@Nullable StatGearKey key, @Nullable StatInstance value) {
        return this.map.put((Object)key, (Object)value);
    }

    public boolean remove(@Nullable Object key, @Nullable Object value) {
        return this.map.remove(key, value);
    }

    public boolean putAll(@Nullable StatGearKey key, @Nonnull Iterable<? extends StatInstance> values) {
        return this.map.putAll((Object)key, values);
    }

    public boolean putAll(@Nonnull Multimap<? extends StatGearKey, ? extends StatInstance> multimap) {
        return this.map.putAll(multimap);
    }

    public Collection<StatInstance> replaceValues(@Nullable StatGearKey key, @Nonnull Iterable<? extends StatInstance> values) {
        return this.map.replaceValues((Object)key, values);
    }

    public Collection<StatInstance> removeAll(@Nullable Object key) {
        return this.map.removeAll(key);
    }

    public void clear() {
        this.map.clear();
    }

    public Collection<StatInstance> get(IItemStat stat, GearType gearType) {
        return this.get(StatGearKey.of(stat, gearType));
    }

    public Collection<StatInstance> get(@Nullable StatGearKey key) {
        if (key == null || this.map.containsKey((Object)key)) {
            return this.map.get((Object)key);
        }
        for (StatGearKey parent = key.getParent(); parent != null; parent = parent.getParent()) {
            if (!this.map.containsKey((Object)parent)) continue;
            return this.map.get((Object)parent);
        }
        return Collections.emptyList();
    }

    public StatGearKey getMostSpecificKey(StatGearKey key) {
        if (this.map.containsKey((Object)key)) {
            return key;
        }
        for (StatGearKey parent = key.getParent(); parent != null; parent = parent.getParent()) {
            if (!this.map.containsKey((Object)parent)) continue;
            return parent;
        }
        return StatGearKey.of(key.getStat(), GearType.ALL);
    }

    public Set<StatGearKey> keySet() {
        return this.map.keySet();
    }

    public Multiset<StatGearKey> keys() {
        return this.map.keys();
    }

    public Collection<StatInstance> values() {
        return this.map.values();
    }

    public Collection<Map.Entry<StatGearKey, StatInstance>> entries() {
        return this.map.entries();
    }

    public Map<StatGearKey, Collection<StatInstance>> asMap() {
        return this.map.asMap();
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        for (StatGearKey key : this.keySet()) {
            Collection<StatInstance> mods = this.get(key);
            if (mods.size() > 1) {
                JsonArray array = new JsonArray();
                mods.forEach(mod -> array.add(mod.serialize()));
                json.add(key.toString(), (JsonElement)array);
                continue;
            }
            if (mods.size() != 1) continue;
            json.add(key.toString(), mods.iterator().next().serialize());
        }
        return json;
    }

    @Deprecated
    public static StatModifierMap deserialize(IGearPart part, JsonElement json) {
        return StatModifierMap.deserialize(json);
    }

    public static StatModifierMap deserialize(JsonElement json) {
        StatModifierMap map = new StatModifierMap();
        if (json.isJsonObject()) {
            for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                StatGearKey key = StatGearKey.read((String)entry.getKey());
                if (key == null) continue;
                JsonElement value = (JsonElement)entry.getValue();
                if (value.isJsonArray()) {
                    for (JsonElement je : value.getAsJsonArray()) {
                        StatInstance mod = StatInstance.read(key, je);
                        map.put(key, mod);
                    }
                    continue;
                }
                map.put(key, StatInstance.read(key, value));
            }
        } else if (json.isJsonArray()) {
            for (JsonElement element : json.getAsJsonArray()) {
                JsonObject jsonObj = element.getAsJsonObject();
                StatGearKey key = StatGearKey.read(GsonHelper.m_13906_((JsonObject)jsonObj, (String)"name"));
                if (key == null) continue;
                map.put(key, StatInstance.read(key, element));
            }
        } else {
            throw new JsonParseException("Expected object or array");
        }
        return map;
    }

    public static StatModifierMap read(FriendlyByteBuf buffer) {
        StatModifierMap map = new StatModifierMap();
        int count = buffer.m_130242_();
        for (int i = 0; i < count; ++i) {
            StatGearKey key = StatGearKey.read(buffer);
            StatInstance instance = StatInstance.read(key, buffer);
            map.put(key, instance);
        }
        return map;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.size());
        this.forEach((key, instance) -> {
            key.write(buffer);
            instance.write(buffer);
        });
    }
}

