/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;

public final class MaterialList
implements List<IMaterialInstance> {
    private final List<IMaterialInstance> list = new ArrayList<IMaterialInstance>();

    private MaterialList() {
    }

    public static MaterialList empty() {
        return new MaterialList();
    }

    public static MaterialList of(Collection<? extends IMaterialInstance> materials) {
        MaterialList ret = new MaterialList();
        ret.list.addAll(materials);
        return ret;
    }

    public static MaterialList of(IMaterialInstance ... materials) {
        MaterialList ret = new MaterialList();
        Collections.addAll(ret.list, materials);
        return ret;
    }

    public static MaterialList deserializeNbt(ListTag listNbt) {
        MaterialList ret = new MaterialList();
        for (int i = 0; i < listNbt.size(); ++i) {
            CompoundTag compoundNbt = listNbt.m_128728_(i);
            MaterialInstance material = MaterialInstance.read(compoundNbt);
            if (material == null) continue;
            int count = compoundNbt.m_128441_("Count") ? compoundNbt.m_128445_("Count") : 1;
            for (int j = 0; j < count; ++j) {
                ret.list.add(material);
            }
        }
        return ret;
    }

    public ListTag serializeNbt() {
        ListTag ret = new ListTag();
        IMaterialInstance last = null;
        int count = 0;
        for (IMaterialInstance material : this.list) {
            if (material.equals(last)) {
                ++count;
                continue;
            }
            if (last != null) {
                ret.add((Object)MaterialList.serializeMaterialWithCount(last, count));
            }
            last = material;
            count = 1;
        }
        if (last != null) {
            ret.add((Object)MaterialList.serializeMaterialWithCount(last, count));
        }
        return ret;
    }

    private static CompoundTag serializeMaterialWithCount(IMaterialInstance material, int count) {
        CompoundTag ret = new CompoundTag();
        material.write(ret);
        if (count > 1) {
            ret.m_128344_("Count", (byte)count);
        }
        return ret;
    }

    @Nullable
    public static IMaterialInstance deserializeFirst(ListTag listNbt) {
        for (int i = 0; i < listNbt.size(); ++i) {
            MaterialInstance material = MaterialInstance.read(listNbt.m_128728_(i));
            if (material == null) continue;
            return material;
        }
        return null;
    }

    public String getModelKey() {
        StringBuilder ret = new StringBuilder("[");
        IMaterialInstance last = null;
        int count = 0;
        int totalWritten = 0;
        for (IMaterialInstance material : this.list) {
            if (material.equals(last)) {
                ++count;
                continue;
            }
            if (last != null) {
                if (totalWritten > 0) {
                    ret.append(",");
                }
                ret.append(MaterialList.makeModelKeyWithCount(last, count));
                ++totalWritten;
            }
            last = material;
            count = 1;
        }
        if (last != null) {
            ret.append(MaterialList.makeModelKeyWithCount(last, count));
        }
        return ret.append("]").toString();
    }

    private static String makeModelKeyWithCount(IMaterialInstance material, int count) {
        if (count > 1) {
            return material.getModelKey() + "*" + count;
        }
        return material.getModelKey();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<IMaterialInstance> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(IMaterialInstance materialInstance) {
        return this.list.add(materialInstance);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends IMaterialInstance> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends IMaterialInstance> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public IMaterialInstance get(int index) {
        return this.list.get(index);
    }

    @Override
    public IMaterialInstance set(int index, IMaterialInstance element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, IMaterialInstance element) {
        this.list.add(index, element);
    }

    @Override
    public IMaterialInstance remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<IMaterialInstance> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<IMaterialInstance> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<IMaterialInstance> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }
}

