/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.placer;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.misc.SlotContainer;
import com.yogpc.qp.machines.placer.PlacerTile;
import com.yogpc.qp.machines.placer.RemotePlacerTile;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PlacerContainer
extends AbstractContainerMenu {
    public static final String PLACER_GUI_ID = "quarryplus:gui_placer_plus";
    public static final String REMOTE_PLACER_GUI_ID = "quarryplus:gui_remote_placer";
    @NotNull
    final PlacerTile tile;
    private final int allSlots;
    final int startX;

    public <T extends PlacerTile> PlacerContainer(int id, Player player, BlockPos pos, Class<T> tileClass) {
        super(PlacerContainer.getTypeFromClass(tileClass), id);
        this.tile = (PlacerTile)tileClass.cast(Objects.requireNonNull(player.m_9236_().m_7702_(pos)));
        this.allSlots = this.tile.m_6643_();
        this.startX = tileClass == PlacerTile.class ? 62 : (tileClass == RemotePlacerTile.class ? 26 : 0);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_(new SlotContainer(this.tile, j + i * 3, this.startX + j * 18, 17 + i * 18));
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.m_38897_(new Slot((Container)player.m_150109_(), i1 + k * 9 + 9, 8 + i1 * 18, 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.m_38897_(new Slot((Container)player.m_150109_(), l, 8 + l * 18, 142));
        }
        if (!player.m_9236_().f_46443_) {
            this.tile.sendPacket();
        }
    }

    private static MenuType<?> getTypeFromClass(Class<?> tileClass) {
        if (tileClass == PlacerTile.class) {
            return Holder.PLACER_MENU_TYPE;
        }
        if (tileClass == RemotePlacerTile.class) {
            return Holder.REMOTE_PLACER_MENU_TYPE;
        }
        throw new IllegalArgumentException("Invalid class: %s".formatted(tileClass));
    }

    public boolean m_6875_(Player playerIn) {
        return this.tile.m_6542_(playerIn);
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = this.m_38853_(index);
        if (slot.m_6657_()) {
            ItemStack remain = slot.m_7993_();
            ItemStack slotContent = remain.m_41777_();
            if (index < this.allSlots ? !this.m_38903_(remain, this.allSlots, 36 + this.allSlots, true) : !this.m_38903_(remain, 0, this.allSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (remain.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (remain.m_41613_() == slotContent.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, remain);
            return slotContent;
        }
        return ItemStack.f_41583_;
    }
}

