/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.module;

import com.yogpc.qp.machines.QPItem;
import com.yogpc.qp.machines.module.ExpModule;
import com.yogpc.qp.machines.module.QuarryModule;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpModuleItem
extends QPItem
implements QuarryModuleProvider.Item {
    public static final String NAME = "exp_module";
    public static final String KEY_AMOUNT = "amount";

    public ExpModuleItem() {
        super(new ResourceLocation("quarryplus", NAME), new Item.Properties().m_41487_(1));
    }

    @Override
    public QuarryModule getModule(@NotNull ItemStack stack) {
        return new ExpItemModule(stack);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, level, list, flag);
        Stream.ofNullable(stack.m_41783_()).mapToInt(t -> t.m_128451_(KEY_AMOUNT)).filter(i -> i >= 0).mapToObj(i -> "Exp: " + i).map(Component::m_237113_).forEach(list::add);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41783_() != null) {
            int exp = stack.m_41783_().m_128451_(KEY_AMOUNT);
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237110_((String)"quarryplus.chat.give_exp", (Object[])new Object[]{exp}), false);
                player.m_6756_(exp);
            }
            stack.m_41749_(KEY_AMOUNT);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    static class ExpItemModule
    extends ExpModule {
        private final ItemStack stack;

        ExpItemModule(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public void addExp(int amount) {
            if (amount == 0) {
                return;
            }
            CompoundTag tag = this.stack.m_41784_();
            int pre = tag.m_128451_(ExpModuleItem.KEY_AMOUNT);
            tag.m_128405_(ExpModuleItem.KEY_AMOUNT, pre + amount);
        }

        @Override
        public int getExp() {
            if (!this.stack.m_41782_()) {
                return 0;
            }
            assert (this.stack.m_41783_() != null);
            return this.stack.m_41783_().m_128451_(ExpModuleItem.KEY_AMOUNT);
        }
    }
}

